/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xpattdef.c
 * -----------------------------------------------------------------*/

/* ----------------------------------------------------------*/
/* This file contains definitions for the pattern parser of  */
/* that are needed for dynamic capabilities and onboard firm-*/
/* ware. */
/* Author: Tilmann Wendel */
/* ----------------------------------------------------------*/

/* ----------------------------------------------- */
/* pattern GUI needs some string lists too         */
/* ----------------------------------------------- */

#include "xpattdef.h"

/* special command list for pattern editor purposes */
bx_param_stringlisttype EXPORT bx_xact_patt_table[] =
{
  { "Int_Ack",              0 },
  { "Special",              1 },
  { "IO_Read",              2 },
  { "IO_Write",             3 },
  { "Reserved_4",           4 },
  { "DevId_Msg",            5 },
  { "Mem_ReadDW",           6 },
  { "Mem_Write",            7 },
  { "Alias Mem_ReadBlk",    8 },
  { "Alias Mem_WriteBlk",   9 },
  { "Config_Read",         10 },
  { "Config_Write",        11 },
  { "Split Compl",         12 },
  { "DAC",                 13 },
  { "Mem_ReadBlk",         14 },
  { "Mem_WriteBlk",        15 },
  { "DONT CARE",           16 },
  { NULL, 0 }
};

/* standard choice for pattern strings */
bx_param_stringlisttype EXPORT bx_std_patt_table[] =
{
  { "0",              0 },
  { "1",              1 },
  { "x",              2 },  /* GUI needs 'x', not a 'X' here ! */
  { NULL,             0 }
};


/* bus state choice for pattern strings */
bx_param_stringlisttype EXPORT bx_bstate_patt_table[]
 = {
  { "Unsync",            0 },
  { "Idle",              1 },
  { "DAC1",              2 },
  { "Addr",              3 },
  { "DAC2",              4 },
  { "Attr",              5 },
  { "Response",          6 },
  { "Wait",              7 },
  { "Transfer",          8 },
  { "Recover",           9 },
  { "Decode",            10},
  { "Term",              11 },
  { "DONT CARE",         12 },
  { NULL,                0 }
};

/* burst order choice for pattern strings */
bx_param_stringlisttype EXPORT bx_x_bx_burst_patt_table[]
 = {
  { "Linear",            0 },
  { "Cachline Wrap",     1 },
  { "DONT CARE",         2 },
  { NULL,                0 }
};

/* term choice for pattern strings */
bx_param_stringlisttype EXPORT bx_term_patt_table[]
 = {
  { "None",               0 },
  { "IAbort",             1 },
  { "Split",              2 },
  { "TAbort",             3 },
  { "Discon_SDP",         4 },
  { "Retry",              5 },
  { "Discon_ADB",         6 },
  { "Completion",         7 },
  { "DONT CARE",          8 },
  { NULL,                 0 }
};

/* burst choice for pattern strings */
bx_param_stringlisttype EXPORT bx_burst_patt_table[]
 = {
  { "invalid",            0 },
  { "single",             1 },
  { "first",              2 },
  { "middle",             3 },
  { "last",               4 },
  { "DONT CARE",          5 },
  { NULL,                 0 }
};

/* decode choice for pattern strings */
bx_param_stringlisttype EXPORT bx_decode_patt_table[]
 = {
  { "dont_know",            0 },
  { "A",                    1 },
  { "B",                    2 },
  { "C",                    3 },
  { "subtractive",          4 },
  { "too_slow",             5 },
  { "DONT CARE",            6 },
  { NULL,                   0 }
};

const bx_patt_infotype EXPORT e2929a_patt_signal_table[] = {
 /*                                                                                    BUS         OBS         ERR        TRAN    */
 {"AD64",         0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                   0x00, NO_BIT_POS, NO_BIT_POS,       0x00,  NULL},
 {"AD32",         0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                   0x20, NO_BIT_POS, NO_BIT_POS,       0x20,  NULL},
 {"CBE7_4",       0, 0xf,         4, BX_PATTM_TRIG | BX_PATTM_COND,                   0x54, NO_BIT_POS, NO_BIT_POS,       0x54,  NULL},
 {"CBE3_0",       0, 0xf,         4, BX_PATTM_TRIG | BX_PATTM_COND,                   0x50, NO_BIT_POS, NO_BIT_POS,       0x50,  NULL},
 {"FRAME",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x40, NO_BIT_POS, NO_BIT_POS,       0x40,  bx_std_patt_table},
 {"IRDY",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x41, NO_BIT_POS, NO_BIT_POS,       0x41,  bx_std_patt_table},
 {"TRDY",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x42, NO_BIT_POS, NO_BIT_POS,       0x42,  bx_std_patt_table},
 {"DEVSEL",       0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x43, NO_BIT_POS, NO_BIT_POS,       0x43,  bx_std_patt_table},
 {"IDSEL",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x44, NO_BIT_POS, NO_BIT_POS,       0x44,  bx_std_patt_table},
 {"STOP",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x45, NO_BIT_POS, NO_BIT_POS,       0x45,  bx_std_patt_table},
 {"ACK64",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5B, NO_BIT_POS, NO_BIT_POS,       0x5B,  bx_std_patt_table},
 {"REQ64",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5A, NO_BIT_POS, NO_BIT_POS,       0x5A,  bx_std_patt_table},
 {"PAR",          0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4A, NO_BIT_POS, NO_BIT_POS,       0x4A,  bx_std_patt_table},
 {"PAR64",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x59, NO_BIT_POS, NO_BIT_POS,       0x59,  bx_std_patt_table},
 {"RST",          0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4B, NO_BIT_POS, NO_BIT_POS,       0x4B,  bx_std_patt_table},
 {"LOCK",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x58, NO_BIT_POS, NO_BIT_POS,       0x58,  bx_std_patt_table},
 {"GNT",          0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x47, NO_BIT_POS, NO_BIT_POS,       0x47,  bx_std_patt_table},
 {"REQ",          0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x46, NO_BIT_POS, NO_BIT_POS,       0x46,  bx_std_patt_table},
 {"SERR",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x49, NO_BIT_POS, NO_BIT_POS,       0x49,  bx_std_patt_table},
 {"PERR",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x48, NO_BIT_POS, NO_BIT_POS,       0x48,  bx_std_patt_table},
 {"INTD",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4C, NO_BIT_POS, NO_BIT_POS,       0x4C,  bx_std_patt_table},
 {"INTC",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4D, NO_BIT_POS, NO_BIT_POS,       0x4D,  bx_std_patt_table},
 {"INTB",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4E, NO_BIT_POS, NO_BIT_POS,       0x4E,  bx_std_patt_table},
 {"INTA",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4F, NO_BIT_POS, NO_BIT_POS,       0x4F,  bx_std_patt_table},
 {"trigio0",      0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5C, NO_BIT_POS, NO_BIT_POS,       0x5C,  bx_std_patt_table},
 {"trigio1",      0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5D, NO_BIT_POS, NO_BIT_POS,       0x5D,  bx_std_patt_table},
 {"trigio2",      0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5E, NO_BIT_POS, NO_BIT_POS,       0x5E,  bx_std_patt_table},
 {"trigio3",      0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5F, NO_BIT_POS, NO_BIT_POS,       0x5F,  bx_std_patt_table},
 {"addr_phase",   0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x60, NO_BIT_POS, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"bstate",       0, 0xf,         4, BX_PATTM_TRIGOBS,                          NO_BIT_POS,      0x100, NO_BIT_POS, NO_BIT_POS,  bx_bstate_patt_table},
 {"decode",       0, 0x5,         3, BX_PATTM_TRIGOBS,                          NO_BIT_POS,      0x110, NO_BIT_POS, NO_BIT_POS,  bx_decode_patt_table},
 {"term",         0, 0x7,         3, BX_PATTM_TRIGOBS,                          NO_BIT_POS,      0x118, NO_BIT_POS, NO_BIT_POS,  bx_term_patt_table},
 {"xact_attr_ad", 0, 0xFFFFFFFF, 32, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x20, NO_BIT_POS, NO_BIT_POS,  NULL},
 {"xact_attr_cbe",0, 0xF,         4, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x40, NO_BIT_POS, NO_BIT_POS,  NULL},
 {"xact_dac",     0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x44, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_cmd",     0, 0xf,         4, BX_PATTM_SQ| BX_PATTM_TRIGOBS,             NO_BIT_POS,      0x145, NO_BIT_POS, NO_BIT_POS,  bx_xact_patt_table},
 {"xact_lock",    0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x55, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_tran64",  0, 0x1,         1, BX_PATTM_SQ | BX_PATTM_TRIGOBS,            NO_BIT_POS,       0x56, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_trigio0", 0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x57, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_trigio1", 0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x58, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_trigio2", 0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x59, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_trigio3", 0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x5A, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"ri_act",       0, 0x1,         1, BX_PATTM_SQ | BX_PATTM_TRIGOBS,            NO_BIT_POS,       0x5B, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"ct_act",       0, 0x1,         1, BX_PATTM_SQ | BX_PATTM_TRIGOBS,            NO_BIT_POS,       0x5C, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"ci_act",       0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x5D, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"rt_act",       0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x5E, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"ri_done",      0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x5F, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"c_rule0",      0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x60, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"c_rule1",      0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x61, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
/* {"c_rule2",      0, 0x1,         1, BX_PATT_STD,                             NO_BIT_POS,       0x62, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table}, */
/* {"c_rule3",      0, 0x1,         1, BX_PATT_STD,                             NO_BIT_POS,       0x63, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table}, */
 {"ri_split_pending",0, 0x1,      1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x64, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"proterr",      0, 0x1,         1, BX_PATTM_ERR,                              NO_BIT_POS, NO_BIT_POS,       0x00, NO_BIT_POS,  bx_std_patt_table},
 {"dcomperr",     0, 0x1,         1, BX_PATTM_ERR,                              NO_BIT_POS, NO_BIT_POS,       0x01, NO_BIT_POS,  bx_std_patt_table},
 {"spliterr",     0, 0x1,         1, BX_PATTM_ERR,                              NO_BIT_POS, NO_BIT_POS,       0x02, NO_BIT_POS,  bx_std_patt_table},
 {NULL,           0,   0,         0, 0,  /* terminating line */                 NO_BIT_POS, NO_BIT_POS, NO_BIT_POS, NO_BIT_POS,  NULL} 
};

const bx_patt_infotype EXPORT e2930a_patt_signal_table[] = {
 /*                                                                                    BUS         OBS         ERR        TRAN    */
 {"AD64",         0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                   0x00, NO_BIT_POS, NO_BIT_POS,       0x00,  NULL},
 {"AD32",         0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                   0x20, NO_BIT_POS, NO_BIT_POS,       0x20,  NULL},
#if 0
 {"AD64_2",       0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                   0x80, NO_BIT_POS, NO_BIT_POS,       0x80,  NULL},
 {"AD32_2",       0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                   0xa0, NO_BIT_POS, NO_BIT_POS,       0xa0,  NULL},
#endif
#if 0
 {"AD64_3",       0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                   0xc0, NO_BIT_POS, NO_BIT_POS,       0xc0,  NULL},
 {"AD32_3",       0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                   0xe0, NO_BIT_POS, NO_BIT_POS,       0xe0,  NULL},
 {"AD64_4",       0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                  0x100, NO_BIT_POS, NO_BIT_POS,       0x100, NULL},
 {"AD32_4",       0, 0xffffffff, 32, BX_PATTM_TRIG | BX_PATTM_COND,                  0x120, NO_BIT_POS, NO_BIT_POS,       0x120, NULL},
#endif
 {"CBE7_4",       0, 0xf,         4, BX_PATTM_TRIG | BX_PATTM_COND,                   0x54, NO_BIT_POS, NO_BIT_POS,       0x54,  NULL},
 {"CBE3_0",       0, 0xf,         4, BX_PATTM_TRIG | BX_PATTM_COND,                   0x50, NO_BIT_POS, NO_BIT_POS,       0x50,  NULL},
 {"FRAME",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x40, NO_BIT_POS, NO_BIT_POS,       0x40,  bx_std_patt_table},
 {"IRDY",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x41, NO_BIT_POS, NO_BIT_POS,       0x41,  bx_std_patt_table},
 {"TRDY",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x42, NO_BIT_POS, NO_BIT_POS,       0x42,  bx_std_patt_table},
 {"DEVSEL",       0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x43, NO_BIT_POS, NO_BIT_POS,       0x43,  bx_std_patt_table},
 {"IDSEL",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x44, NO_BIT_POS, NO_BIT_POS,       0x44,  bx_std_patt_table},
 {"STOP",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x45, NO_BIT_POS, NO_BIT_POS,       0x45,  bx_std_patt_table},
 {"ACK64",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5B, NO_BIT_POS, NO_BIT_POS,       0x5B,  bx_std_patt_table},
 {"REQ64",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5A, NO_BIT_POS, NO_BIT_POS,       0x5A,  bx_std_patt_table},
 {"PAR",          0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4A, NO_BIT_POS, NO_BIT_POS,       0x4A,  bx_std_patt_table},
 {"PAR64",        0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x59, NO_BIT_POS, NO_BIT_POS,       0x59,  bx_std_patt_table},
 {"RST",          0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4B, NO_BIT_POS, NO_BIT_POS,       0x4B,  bx_std_patt_table},
 {"LOCK",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x58, NO_BIT_POS, NO_BIT_POS,       0x58,  bx_std_patt_table},
 {"GNT",          0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x47, NO_BIT_POS, NO_BIT_POS,       0x47,  bx_std_patt_table},
 {"REQ",          0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x46, NO_BIT_POS, NO_BIT_POS,       0x46,  bx_std_patt_table},
 {"SERR",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x49, NO_BIT_POS, NO_BIT_POS,       0x49,  bx_std_patt_table},
 {"PERR",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x48, NO_BIT_POS, NO_BIT_POS,       0x48,  bx_std_patt_table},
 {"INTD",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4C, NO_BIT_POS, NO_BIT_POS,       0x4C,  bx_std_patt_table},
 {"INTC",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4D, NO_BIT_POS, NO_BIT_POS,       0x4D,  bx_std_patt_table},
 {"INTB",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4E, NO_BIT_POS, NO_BIT_POS,       0x4E,  bx_std_patt_table},
 {"INTA",         0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x4F, NO_BIT_POS, NO_BIT_POS,       0x4F,  bx_std_patt_table},
 {"trigio0",      0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5C, NO_BIT_POS, NO_BIT_POS,       0x5C,  bx_std_patt_table},
 {"trigio1",      0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5D, NO_BIT_POS, NO_BIT_POS,       0x5D,  bx_std_patt_table},
 {"trigio2",      0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5E, NO_BIT_POS, NO_BIT_POS,       0x5E,  bx_std_patt_table},
 {"trigio3",      0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x5F, NO_BIT_POS, NO_BIT_POS,       0x5F,  bx_std_patt_table},
 {"addr_phase",   0, 0x1,         1, BX_PATTM_TRIG | BX_PATTM_COND,                   0x60, NO_BIT_POS, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"bstate",       0, 0xf,         4, BX_PATTM_TRIGOBS,                          NO_BIT_POS,      0x100, NO_BIT_POS, NO_BIT_POS,  bx_bstate_patt_table},
 {"decode",       0, 0x5,         3, BX_PATTM_TRIGOBS,                          NO_BIT_POS,      0x110, NO_BIT_POS, NO_BIT_POS,  bx_decode_patt_table},
 {"term",         0, 0x7,         3, BX_PATTM_TRIGOBS,                          NO_BIT_POS,      0x118, NO_BIT_POS, NO_BIT_POS,  bx_term_patt_table},
 {"xact_attr_ad", 0, 0xFFFFFFFF, 32, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x20, NO_BIT_POS, NO_BIT_POS,  NULL},
 {"xact_attr_cbe",0, 0xF,         4, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x40, NO_BIT_POS, NO_BIT_POS,  NULL},
 {"xact_dac",     0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x44, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_cmd",     0, 0xf,         4, BX_PATTM_SQ| BX_PATTM_TRIGOBS,             NO_BIT_POS,      0x145, NO_BIT_POS, NO_BIT_POS,  bx_xact_patt_table},
 {"xact_lock",    0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x55, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_tran64",  0, 0x1,         1, BX_PATTM_SQ | BX_PATTM_TRIGOBS,            NO_BIT_POS,       0x56, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_trigio0", 0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x57, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_trigio1", 0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x58, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_trigio2", 0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x59, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"xact_trigio3", 0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x5A, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"ri_act",       0, 0x1,         1, BX_PATTM_SQ | BX_PATTM_TRIGOBS,            NO_BIT_POS,       0x5B, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"ct_act",       0, 0x1,         1, BX_PATTM_SQ | BX_PATTM_TRIGOBS,            NO_BIT_POS,       0x5C, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"ci_act",       0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x5D, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"rt_act",       0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x5E, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"ri_done",      0, 0x1,         1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x5F, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"c_rule0",      0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x60, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"c_rule1",      0, 0x1,         1, BX_PATTM_NONE,                             NO_BIT_POS,       0x61, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
/* {"c_rule2",      0, 0x1,         1, BX_PATT_STD,                             NO_BIT_POS,       0x62, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table}, */
/* {"c_rule3",      0, 0x1,         1, BX_PATT_STD,                             NO_BIT_POS,       0x63, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table}, */
 {"ri_split_pending",0, 0x1,      1, BX_PATTM_TRIGOBS,                          NO_BIT_POS,       0x64, NO_BIT_POS, NO_BIT_POS,  bx_std_patt_table},
 {"proterr",      0, 0x1,         1, BX_PATTM_ERR,                              NO_BIT_POS, NO_BIT_POS,       0x00, NO_BIT_POS,  bx_std_patt_table},
 {"dcomperr",     0, 0x1,         1, BX_PATTM_ERR,                              NO_BIT_POS, NO_BIT_POS,       0x01, NO_BIT_POS,  bx_std_patt_table},
 {"spliterr",     0, 0x1,         1, BX_PATTM_ERR,                              NO_BIT_POS, NO_BIT_POS,       0x02, NO_BIT_POS,  bx_std_patt_table},
 {NULL,           0,   0,         0, 0,  /* terminating line */                 NO_BIT_POS, NO_BIT_POS, NO_BIT_POS, NO_BIT_POS,  NULL} 
};

